// global variables

function addConsoleOutput( content ) {
  var p = document.getElementById( 'idConsole' );
  if( p && content && content.length ) {
    p.innerHTML = p.innerHTML + content.replace(/__nl__/g, "\n" );
    p.scrollTop = p.scrollHeight;
  }
};

function setStateValue( sElementId, value ) {
  p = document.getElementById( sElementId );
  if( p && ( value != 'undefined' ) ) {
    p.innerHTML = value;
  }
};

function handleResponseContent_( rspContent ) {
     
    var opTime = rspContent.opTime || 0;
    setStateValue( 'idT1', Number( rspContent.t1 ).toFixed( 2 ) );
  
    setStateValue( 'idT2', Number( rspContent.t2 ).toFixed( 2 ) );
    setStateValue( 'idT3', Number( rspContent.t3 ).toFixed( 2 ) );
    setStateValue( 'idT4', Number( rspContent.t4 ).toFixed( 2 ) );
    setStateValue( 'idT5', Number( rspContent.t5 ).toFixed( 2 ) );

    setStateValue( 'idHum',                     rspContent.hum              );
    setStateValue( 'idPowerOwn',                rspContent.powOwn           );
    setStateValue( 'idPowerMean',               rspContent.powMean          );
    setStateValue( 'idEnergyOwn',               rspContent.energyOwn        );
    setStateValue( 'idPowerHeat',               rspContent.powHeat          );
    setStateValue( 'ifHighPowerActive',               rspContent.highPowerActive          );
    setStateValue( 'idEnergyOwnRel',            rspContent.energyOwnRel     );
    setStateValue( 'idEnergyConsumptionPerDay', rspContent.energyConsPerDay );
    setStateValue( 'idMobileState',             rspContent.mobileState      );
    setStateValue( 'idImgUpdCntrl',             rspContent.stateImgUpdCntrl );
    setStateValue( 'idStateVisHandMode',        rspContent.stateVisHcMode   );
    setStateValue( 'idStateScheduler',          rspContent.stateScheduler   );
    setStateValue( 'idPacosAddr',               rspContent.pacosAddr        );
    setStateValue( 'idPacosLastContact',        rspContent.pacosLastContact );
    setStateValue( 'idDabState',                rspContent.dabState         );
    setStateValue( 'idCalModeState',            rspContent.calModeState     );
    setStateValue( 'idPowerFailModeState',      rspContent.powerFailModeState );

    setStateValue( 'idImageUpdateCount',        rspContent.imgUpdCnt        );
    setStateValue( 'idKey0KeystrokeCnt',        rspContent.key0KeyStrokeCnt );
    setStateValue( 'idKey7KeystrokeCnt',        rspContent.key7KeyStrokeCnt );
    setStateValue( 'idKey9KeystrokeCnt',        rspContent.key9KeyStrokeCnt );
    setStateValue( 'idKey10KeystrokeCnt',       rspContent.key10KeyStrokeCnt );
    setStateValue( 'idKey11KeystrokeCnt',       rspContent.key11KeyStrokeCnt );
    setStateValue( 'idVhcmActivationCnt',       rspContent.vhcmActivationCnt );
  
    handleResponseContent( rspContent );
};

function index_rsp() {
  var result = comm_get_result( req_idx ) || null;
  if( result ) {
    console.log( 'received idx rsp' );
    handleResponseContent_( result );
  }
};

function run_page() {
  console.log( 'start index' );
  pageCntrl_setInterval( function(){comm_action('getIndex',{state:true}, handleResponseContent_);},1000);
};
