
dcsHtmlSelectionOption = function( sName, sValue, boSelected, sNameTag ) {
    this.m_name = sName || '';
    this.m_value = sValue || '';
    this.m_boSlected = boSelected || false;
    this.m_sNameTag = sNameTag || null;
    
    this.name = function() { return this.m_name; };
    this.value = function() { return this.m_value; };
    this.selected = function() { return this.m_boSlected == true; };
    
    this.select = function( boSelected ) { this.m_boSlected = boSelected || false; };
    
    this.html = function() {
        var sHtml = '<option';
        sHtml += ' value="' + this.m_value + '"';
        if( this.m_boSlected && ( this.m_boSlected === true ) ) { sHtml += ' selected="selected"'; }
        if( this.m_sNameTag ) { sHtml += ' name="' + this.m_sNameTag + '"'; }
        sHtml += '>';
        sHtml += this.m_name;
        sHtml += '</option>';
        return sHtml;
    };
};
dcsHtmlSelectionOption.prototype.constructor = dcsHtmlSelectionOption;

dcsHtmlCheckBox = function( checked, cbOnClicked, id ) {
    checked = checked ||false;
    cbOnClicked = cbOnClicked || null;
    id = id || null;
    return '<input type="checkbox"' +
            (id&&id.length?' id="' + id + '"':'') +
            (cbOnClicked?' onclick="' + cbOnClicked + ';"':'') +
            (checked?' checked="checked"':'') + '/>';
};

dcsHtmlSelection = function( id, iSize, cbOnChange, cbOnClick ) {
    this.m_id = id || null;
    this.m_size = iSize || 1;
    this.m_options = new Array();
    this.m_pFcnOnChange = cbOnChange || null;
    this.m_pFcnOnClick = cbOnClick || null;
    
    this.getOnChangeCall = function()
    {
        var sRet = '';
        if( this.m_pFcnOnChange ) { sRet = ' onchange="' + this.m_pFcnOnChange + '"'; }
        return sRet;
    };
    
    this.getOnClickCall = function()
    {
        var sRet = '';
        if( this.m_pFcnOnClick ) { sRet = ' onclick="' + this.m_pFcnOnClick + '"'; }
        return sRet;
    };
    
    this.addOption = function( sName, sValue, boSelected, sNameTag )
    {
        sName = sName || '';
        sNameTag = sNameTag || null;
        if( boSelected ) {
            // unselect all other options
            for( var i=0; i<this.m_options.length; i++ ) {
                this.m_options[ i ].select( false );
            }
        }
        this.m_options.push( new dcsHtmlSelectionOption( sName, sValue, boSelected, sNameTag ) );
    };
    
    this.html = function() {
        var boSelected = false;
        for( var i=0; i<this.m_options.length; i++ ) {
            if( this.m_options[ i ] && this.m_options[ i ].selected() ) {
                boSelected = true;
            }
        }
        if( !boSelected && this.m_options.length ) {
            this.m_options[ 0 ].select( true );
        }
        var sSelection = '<select size="' + this.m_size + '" ' + this.getOnChangeCall() + this.getOnClickCall();
        if( this.m_id ) sSelection += ' id="' + this.m_id + '"';
        sSelection += '>';
        for( var i=0; i<this.m_options.length; i++ ) {
            if( this.m_options[ i ] ) sSelection += this.m_options[ i ].html();
        }
        sSelection += '</select>';
        return sSelection;
    };
};
dcsHtmlSelection.prototype.constructor = dcsHtmlSelection;

function padLeadingZero( num, size ) {  
    var s = num+"";
    while (s.length < size) s = "0" + s;
    return s;
};

function getDaytimeSecondsFromHourMinuteSelector( sName ) {
    return (Number(j('#hour_'+sName).attr('value'))*3600)+(Number(j('#minute_'+sName).attr('value'))*60);
};

function getDaytimeSecondsFromHourMinuteSelectorFromParent( parentSelector, sName ) {
    var oHourSel = j(parentSelector).find('#hour_'+sName);
    var oMinuSel = j(parentSelector).find('#minute_'+sName);
    var iHour = j(oHourSel).prop('value');
    var iMinu = j(oMinuSel).prop('value');
    return (Number(iHour)*3600)+(Number(iMinu)*60);
};

function getHourMinuteSelector( sName, dayTimeSeconds, cbOnChange, cbOnChangeSet )
{
    var sHourId = 'hour_' + sName;
    var sMinuteId = 'minute_' + sName;
    var cdOnChangeBoth = null;
    cbOnChange = cbOnChange || null;
    cbOnChangeSet = cbOnChangeSet || null;
    if( cbOnChange ) {
        cdOnChangeBoth = "var val = (Number(j('#" + sHourId +   "').attr('value'))*3600)+" + 
                                   "(Number(j('#" + sMinuteId + "').attr('value'))*60);" + cbOnChange + "({" + (cbOnChangeSet?(cbOnChangeSet + ","):"") + "value:val});";
    }
    
    var oSelectionHour = new dcsHtmlSelection( sHourId, 1, cdOnChangeBoth );
    var iSelectedHour = parseInt( dayTimeSeconds / 3600 );
    var iSelectedMinute = parseInt( ( dayTimeSeconds % 3600 ) / 60 );
    
    //console_log( 'desired hour/minute: ' + iSelectedHour + '/' + iSelectedMinute );
    
    for( var i=0; i<24; i++ ) {
        oSelectionHour.addOption( padLeadingZero( i, 2 ), String( parseInt( i ) ), iSelectedHour === i );
    }
    var oSelectionMinute = new dcsHtmlSelection( sMinuteId, 1, cdOnChangeBoth );
    for( var i=0; i<60; i+=5 ) {
        oSelectionMinute.addOption( padLeadingZero( i, 2 ), String( parseInt( i ) ), iSelectedMinute === i );
    }
    return oSelectionHour.html() + ':' + oSelectionMinute.html();
};

function getCurrentDayTimeSeconds()
{
  var temp = new Date();
  return ( temp.getHours() * 3600 ) + ( temp.getMinutes() * 60 ) + temp.getSeconds();
};

function getTimeDateString( iTimeSinceEpoch_s ) { 
  var t = new Date();
  t.setTime( iTimeSinceEpoch_s * 1000 );
  
  return padLeadingZero(t.getDate(),2) + '.' +
         padLeadingZero(t.getMonth()+1,2) + '.' +
         t.getFullYear() + ' - ' +
         padLeadingZero(t.getHours(),2) + ':' +
         padLeadingZero(t.getMinutes(),2);
};

function getImageWithLink( sImageId, sMimeType, sTitle ) {
    sTitle = sTitle || '';
    sImageId = ( sImageId !== undefined )?sImageId:0;
    sMimeType = ( sMimeType !== undefined )?sMimeType:'';
    if( sTitle.length ) {
        sTitle = ' title="' + sTitle + '"';
    }
    var imageLinkAssignedToScheduleEntry = '/php/images.php?dwnFileId=' + sImageId;
    var thumbImageLinkAssignedToScheduleEntry = '/php/images.php?thumbImgId=' + sImageId;
    if( sMimeType == 'application/pdf' ) {
        thumbImageLinkAssignedToScheduleEntry = '/img/pdf-icon-png-2063.png';
    } 
    return '<a href="#" onclick="window.open(\'' + imageLinkAssignedToScheduleEntry + '\', \'\', \'scrollbars=0, width=400, height=600\');"><img src="' + thumbImageLinkAssignedToScheduleEntry + '" height="50px"' + sTitle + '/></a>'; 
};

var g_dateTimeCount = 0;

var CDateTime = Class.create({
  m_calendar: null,
  m_idDateInput: '', 
  m_idHour: '', 
  m_idMinute: '',
  m_lang: 0,
  m_sDateFormat: Calendar.DEFAULT_FORMAT,
  onChangeTime : function( value ) {
  },
  initialize: function( idParent, name, integrityCallback ) {
    name = name || "dummy";
    var parentNode = document.getElementById( idParent );
    if( parentNode ) {
      var sDateTimeIntegritiCallback = '';
      var dateNow = new Date();
      if( integrityCallback ) { 
        sDateTimeIntegritiCallback = ' onchange="' + integrityCallback + '();"';
      }
      var sUid = g_dateTimeCount ++;
      this.m_idDateInput = name + '_date_' + sUid;
      this.m_idHour = 'hour_' + name + '_' + sUid;
      this.m_idMinute = 'minute_' + name + '_' + sUid; 
      var sDateInput = '<input id="' + this.m_idDateInput + '" value="' + dateNow.print( this.m_sDateFormat, this.m_lang ) + '"' + sDateTimeIntegritiCallback + ' size="10"/>';
      parentNode.innerHTML = sDateInput + getHourMinuteSelector( name + '_' + sUid, getCurrentDayTimeSeconds(), integrityCallback ); 
      Calendar.setup( { dateField: this.m_idDateInput,
                        triggerElement: this.m_idDateInput,
                        lang: this.m_lang } );
    }
  },
  enable: function( boEna ) {
    j( '#' + this.m_idDateInput ).prop( 'disabled', !boEna );
    j( '#' + this.m_idHour ).prop( 'disabled', !boEna );
    j( '#' + this.m_idMinute ).prop( 'disabled', !boEna );
  },
  getDateTime: function() {
    var date = Date.parseDate( j( '#' + this.m_idDateInput ).attr( 'value' ), this.m_sDateFormat );
    date.setSeconds( 0 );
    date.setHours( j( '#' + this.m_idHour ).attr( 'value' ) );
    date.setMinutes( j( '#' + this.m_idMinute ).attr( 'value' ) );
    console_log( 'try to retrieve date time: ' + date.toLocaleString() );
    return date;
  },
  setDateTime: function( dateTime ) {
    j( '#' + this.m_idDateInput ).attr( 'value', dateTime.print( this.m_sDateFormat, this.m_lang ) );
    j( '#' + this.m_idHour      ).attr( 'value', dateTime.getHours() );
    j( '#' + this.m_idMinute    ).attr( 'value', Math.floor( dateTime.getMinutes() / 5 ) * 5 );
  }  
});