#!/bin/bash

ARITTS_APP=/opt/aristech/client/AriTTS-go-client
ARITTS_SCR=/opt/aristech/client/num.sqr
OUTPUT_DIR=/mnt/dezign/work/tmp

mkdir -p ${OUTPUT_DIR}

if [ "$#" -gt 1 ] ; then
  #we expect tts text as par 1 and refimage (without path) as par 2
  TTS_TEST=$1
  TTS_REF_IMAGE=$2
  TTS_FILE_RAW=${OUTPUT_DIR}/${TTS_REF_IMAGE}.raw
  TTS_FILE_RAW_TMP=/tmp/${TTS_REF_IMAGE}_temp_tts.raw
  OUTPUT_FILE=${OUTPUT_DIR}/${TTS_REF_IMAGE}.log

  lockdir=/tmp/aritts_convert_${TTS_REF_IMAGE}_tts.lock
  
  if  mkdir "$lockdir"
  then
      echo "start conversion"
  else
      echo "conversion in progress, cannot start"
      exit 1
  fi
  
  trap 'rm -rf "$lockdir"' 0
  
  rm -f ${TTS_FILE_RAW}
  
  sync
  
  echo "play ${TTS_TEST} to file ${TTS_FILE_RAW}"
  
  ${ARITTS_APP} -host localhost -port 8423 -text "${TTS_TEST}" -type "AUDIO" -voice "cle" -output ${TTS_FILE_RAW_TMP} -sqr ${ARITTS_SCR} 2>&1> ${OUTPUT_FILE}
# /opt/aristech/client/AriTTS-go-client -host localhost -port 8423 -text "test" -type "AUDIO" -voice "cle" -output ~/test1.raw -sqr /opt/aristech/client/num.sqr 2>&1> OUTPUT_FILE  
  
  mv ${TTS_FILE_RAW_TMP} ${TTS_FILE_RAW}
  sync
else
  echo 'not enough parameter'
fi