#!/bin/sh

clear

echo "unit test"
valgrind --tool=memcheck \
  --leak-check=full \
  --show-reachable=yes \
  --track-origins=yes \
  --track-fds=yes \
  --suppressions=/home/root/suppressions_dzTest.supp \
  --gen-suppressions=all \
  --log-file=dzTest_t1_unit.txt \
  dzTest -unit
  
cat dzTest_t1_unit.txt

echo "test loading loadable image"  
valgrind --tool=memcheck \
  --leak-check=full \
  --show-reachable=yes \
  --track-origins=yes \
  --track-fds=yes \
  --suppressions=/home/root/suppressions_dzTest.supp \
  --gen-suppressions=all \
  --log-file=dzTest_t2_png_good.txt \
  dzTest -loadPng=/home/root/muenchen.png

cat dzTest_t2_png_good.txt

echo "test loading unloadable (damaged) image"  
valgrind --tool=memcheck \
  --leak-check=full \
  --show-reachable=yes \
  --track-origins=yes \
  --track-fds=yes \
  --keep-debuginfo=yes \
  --suppressions=/home/root/suppressions_dzTest.supp \
  --gen-suppressions=all \
  --log-file=dzTest_t3_png_damaged.txt \
  dzTest -loadPng=/home/root/muenchen.png_unsupported.png
  
cat dzTest_t3_png_damaged.txt