#!/bin/bash

#ARITTS_APP=/opt/aristech/client/AriTTS-go-client
OUTPUT_DIR=/mnt/dezign/work/tmp

dz_notify() {
  mqueue_push -m /dzMsgIn -p "$1"
}
exit_script() {
  echo "exit playback"
}

trap exit_script EXIT SIGINT SIGABRT SIGTERM SIGTRAP SIGKILL

if [ "$#" -gt 0 ] ; then
  #we expect refimage (without path) as par 1
  AUDIO_VOL=80 
  if [ "$#" -gt 1 ] ; then
    AUDIO_VOL=$2
  fi
  TTS_REF_IMAGE=$1
  TTS_FILE_RAW=${OUTPUT_DIR}/${TTS_REF_IMAGE}.raw
  TTS_FILE_PLAY_RAW=${OUTPUT_DIR}/${TTS_REF_IMAGE}_play.raw

  if [ -f "${TTS_FILE_RAW}" ]; then

    cp ${TTS_FILE_RAW} ${TTS_FILE_PLAY_RAW}
    amixer -c 1 sset 'Speaker' ${AUDIO_VOL}%
    amixer -c 1 sset 'PCM' ${AUDIO_VOL}%

    # if playing audio file takes longer than 2 Minutes,
    # the process will be killed
    timeout 2m aplay ${TTS_FILE_PLAY_RAW} -f S16_LE -c 1 -r 8000 -t raw
    
    rm ${TTS_FILE_PLAY_RAW}
  else
    dz_notify "file to play not present"
  fi
else
  dz_notify 'not enough parameter'
fi
