
check_package ()
{
  if [ -f $1 ]; then
    name_pack=$(dpkg -I $1|grep -e "Package:"|sed -r 's/Package:[[:space:]]//g')
    PKG_OK=$(dpkg-query -W --showformat='${Status}\n' ${name_pack}|grep "install ok installed"|sed -r 's/[[:space:]]//g')
    echo "check if package ${name_pack} exists"
    if [ -z "${PKG_OK}" ]; then
      echo "package not present: ${name_pack}, install it"
        dpkg -i $1
    else
      echo "package present: ${name_pack}"
    fi
  fi
}

install_common ()
{  
  echo "remove avr firmware"
  rm ${HAFA_DIR}/work/fw/*
    
  if [ -f ${HAFA_DIR}/update/dezign.wdt ]; then
    echo "new watchdog script"
    mv -f ${HAFA_DIR}/update/dezign.wdt /home/root/de/dezign/
  fi
}

install_pack ()
{  
  if [ -f $1 ]; then
    echo "install package $1"
    opkg --force-reinstall install $1
  fi
}

#check if we have additional parameter
PAR1=""
if [ "$#" -gt 0 ] ; then
  PAR1=$1
fi

HAFA_DIR=/home/root/de/dezign

if [ -d /mnt/hafa/work ] ; then
  HAFA_DIR=/mnt/hafa
fi

if [ -d /mnt/dezign/work ] ; then
  HAFA_DIR=/mnt/dezign
fi

chmod -R 755 ${HAFA_DIR}/update/*

mkdir -p /home

mkdir -p /home/root
mkdir -p /mnt/dezign

mkdir -p ${HAFA_DIR}/work/fonts

mkdir -p ${HAFA_DIR}/work/dab

mkdir -p ${HAFA_DIR}/work/Images

mkdir -p ${HAFA_DIR}/work/dab/firmware

mkdir -p ${HAFA_DIR}/work/dab/MotData

case $(uname -r) in
  '3.8.13-bone67' )
    ;;
  '5.2.7-dezign' )
    echo 'new system (kernel 5.2.7)'
    ;;
esac

if [ -f ${HAFA_DIR}/work/dab/firmware/dab_radio_3_2_1.bin ]; then
  echo "remove old dab firmware"
  rm ${HAFA_DIR}/work/dab/firmware/dab_radio_3_2_1.bin
fi



case $(uname -r) in
  '3.8.13-bone67' )
    echo 'old system (kernel 3.8.13)'
    
    SYS_CAPE_MGR=/sys/devices/bone_capemgr.8
    
    if [ -d /sys/devices/bone_capemgr.9 ] ; then
      SYS_CAPE_MGR=/sys/devices/bone_capemgr.9
      echo "use cape manager 9"
    else
      echo "use cape manager 8"
    fi
    
    if [ -d /home/root/de/development ] ; then
      rm -r /home/root/de/development
    fi

    if [ -d /root/de/development ] ; then
      rm -r /root/de/development
    fi

    #/boot/uEnv.txt manipulation
    if [ -f /boot/uEnv.txt ]; then
      echo "uEnv.txt file exists"
      echo "uname_r=3.8.13-bone67" > /tmp/uEnv.txt
      echo "cmdline=quiet init=/lib/systemd/systemd" >> /tmp/uEnv.txt
      echo "capemgr.enable_partno=BB-BONE-EMMC-2G,BB-SPI0-01,BB-UART1,DM-GPIO-Test,cape-bone-iio" >> /tmp/uEnv.txt
      echo "optargs=quiet capemgr.disable_partno=BB-BONELT-HDMI,BB-BONELT-HDMIN" >> /tmp/uEnv.txt
      cat /boot/uEnv.txt | grep uuid >> /tmp/uEnv.txt
      echo "new uEnv.txt is:"
      cat /tmp/uEnv.txt
      mv /tmp/uEnv.txt /boot/
    fi

    # install packages

    PACKAGES_DIR=${HAFA_DIR}/update/packages
    check_package ${PACKAGES_DIR}/libpng12-0_1.2.50-2+deb8u3_armhf.deb
    check_package ${PACKAGES_DIR}/minicom_2.6.1-1_armhf.deb
    check_package ${PACKAGES_DIR}/python-central_0.6.17_all.deb
    check_package ${PACKAGES_DIR}/iptables-persistent_0.5.7+deb7u1_all.deb
    check_package ${PACKAGES_DIR}/fail2ban_0.8.6-3wheezy3_all.deb
    check_package ${PACKAGES_DIR}/libvorbisfile3_1.3.2-1.3_armhf.deb
    check_package ${PACKAGES_DIR}/libflac8_1.2.1-6+deb7u1_armhf.deb
    check_package ${PACKAGES_DIR}/libogg-dev_1.3.0-4_armhf.deb
    check_package ${PACKAGES_DIR}/libvorbis-dev_1.3.2-1.3_armhf.deb
    check_package ${PACKAGES_DIR}/libflac-dev_1.2.1-6+deb7u1_armhf.deb
    check_package ${PACKAGES_DIR}/libsndfile1-dev_1.0.25-5_armhf.deb
    check_package ${PACKAGES_DIR}/libboost-system1.49.0_1.49.0-3.2_armhf.deb
    check_package ${PACKAGES_DIR}/libboost-iostreams1.49.0_1.49.0-3.2_armhf.deb
    check_package ${PACKAGES_DIR}/hostapd_1.0-3+deb7u5_armhf.deb
    check_package ${PACKAGES_DIR}/wireless-tools_30~pre9-8_armhf.deb
    check_package ${PACKAGES_DIR}/libnetfilter-conntrack3_1.0.1-1_armhf.deb
    check_package ${PACKAGES_DIR}/dnsmasq-base_2.62-3+deb7u4_armhf.deb
    check_package ${PACKAGES_DIR}/dnsmasq_2.62-3+deb7u4_all.deb
    check_package ${PACKAGES_DIR}/iw_3.4-1_armhf.deb
    check_package ${PACKAGES_DIR}/firmware-linux-free_3.2_all.deb
    check_package ${PACKAGES_DIR}/libopts25_5.12-0.1_armhf.deb
    check_package ${PACKAGES_DIR}/ntp_4.2.6.p5+dfsg-2+deb7u7_armhf.deb

    install_common

    # copy files AFTER installing packages
    if [ -d ${HAFA_DIR}/update/toFs ]; then
      echo "found files for direct copy to filesystem"
      cp -r ${HAFA_DIR}/update/toFs/* /
      rm -r ${HAFA_DIR}/update/toFs/*
    fi

    echo "generate links"
    ln -s -T /usr/lib/libbacktrace.so /usr/lib/libbacktrace.so.0
    ln -s -T /usr/lib/libboost_system.so /usr/lib/libboost_system.so.1.49.0

    if [ -f ${HAFA_DIR}/update/clock_init.sh ]; then
      echo "new clock_init.sh"
      mv -f ${HAFA_DIR}/update/clock_init.sh /usr/share/rtc_ds1307/
    fi

    if [ -f ${HAFA_DIR}/update/fstab ]; then
      echo "new fstab"
      mv -f ${HAFA_DIR}/update/fstab /etc/
    fi

    if [ -e /dev/mmcblk0p3 ]; then
      if [ -f ${HAFA_DIR}/update/fstab.p3 ]; then
        echo "new fstab - p3"
        mv -f ${HAFA_DIR}/update/fstab.p3 /etc/fstab
      fi
    else
      if [ -f ${HAFA_DIR}/update/fstab.p2 ]; then
        echo "new fstab - p2"
        mv -f ${HAFA_DIR}/update/fstab.p2 /etc/fstab
      fi
    fi

    mv -f ${HAFA_DIR}/update/*.png ${HAFA_DIR}/work/

    if [ -f ${HAFA_DIR}/update/ssl_cert.pem ]; then
      echo "new ssl certificate"
      mv -f ${HAFA_DIR}/update/ssl_cert.pem ${HAFA_DIR}/work/
    fi

    if [ -f ${HAFA_DIR}/update/dtbo/DM-GPIO-Test-00A0.dtbo ]; then
      cp ${HAFA_DIR}/update/dtbo/DM-GPIO-Test-00A0.dtbo /home/root/de/dt/
    fi

    #if [ -f ${HAFA_DIR}/update/dtbo/BB-SPI0-01-00A0.dtbo ]; then
    #  cp ${HAFA_DIR}/update/dtbo/BB-SPI0-01-00A0.dtbo /home/root/de/dt/
    #fi

    SPI_NUM=$(cat ${SYS_CAPE_MGR}/slots | grep SPI0 | awk -F: '{print $1}')

    mv -f ${HAFA_DIR}/update/dtbo/*.dtbo /lib/firmware/
    ;;
  '5.2.7-dezign' )
    echo 'new system (kernel 5.2.7)'

    install_common

    mkdir -p ${HAFA_DIR}/bin

    NEW_BIN_DIR=${HAFA_DIR}/bin/$(cat version | tr -d '\r')
    mkdir -p ${NEW_BIN_DIR}

    echo "install packages to root fs"
    CUR_DIR=${pwd}

    mkdir -p ${HAFA_DIR}/update/tmp

    if [ -f ${HAFA_DIR}/update/5.2/packages/libpng16-16_1.6.39-r0_cortexa8hf-neon.ipk ]; then
      echo "new libpng"
      opkg --force-reinstall install ${HAFA_DIR}/update/5.2/packages/libpng16-16_1.6.39-r0_cortexa8hf-neon.ipk
      rm  ${HAFA_DIR}/update/5.2/packages/libpng16-16_1.6.39-r0_cortexa8hf-neon.ipk
    fi

    echo 'try to install new ovpn'    
    install_pack ${HAFA_DIR}/update/5.2/packages/lz4_1.8.3-r0_cortexa8hf-neon.ipk
    install_pack ${HAFA_DIR}/update/5.2/packages/libcap-ng0_0.7.9-r0_cortexa8hf-neon.ipk
    install_pack ${HAFA_DIR}/update/5.2/packages/openvpn_2.6.3-r0_cortexa8hf-neon.ipk
    
    echo 'try to fix fail2ban'
    install_pack ${HAFA_DIR}/update/5.2/packages/python3-fail2ban_0.10.4.0-r0_cortexa8hf-neon.ipk
    
    echo 'intsall deZign firmware'

    install_pack ${HAFA_DIR}/update/5.2/packages/libpngde_1.0-0_cortexa8hf-neon.ipk
    install_pack ${HAFA_DIR}/update/5.2/packages/libpngde-dbg_1.0-0_cortexa8hf-neon.ipk

    install_pack ${HAFA_DIR}/update/5.2/packages/libutf8proc_1.0-0_cortexa8hf-neon.ipk
    install_pack ${HAFA_DIR}/update/5.2/packages/libutf8proc-dbg_1.0-0_cortexa8hf-neon.ipk

    install_pack ${HAFA_DIR}/update/5.2/packages/libvt_1.0-0_cortexa8hf-neon.ipk
    install_pack ${HAFA_DIR}/update/5.2/packages/libvt-dbg_1.0-0_cortexa8hf-neon.ipk

    install_pack ${HAFA_DIR}/update/5.2/packages/libdeimage_1.0-0_cortexa8hf-neon.ipk
    install_pack ${HAFA_DIR}/update/5.2/packages/libdeimage-dbg_1.0-0_cortexa8hf-neon.ipk

    install_pack ${HAFA_DIR}/update/5.2/packages/libboardid_1.0-0_cortexa8hf-neon.ipk
    install_pack ${HAFA_DIR}/update/5.2/packages/libboardid-dbg_1.0-0_cortexa8hf-neon.ipk

    install_pack ${HAFA_DIR}/update/5.2/packages/libcyusb_1.0-0_cortexa8hf-neon.ipk
    install_pack ${HAFA_DIR}/update/5.2/packages/libcyusb-dbg_1.0-0_cortexa8hf-neon.ipk

    install_pack ${HAFA_DIR}/update/5.2/packages/libdedab_1.0-0_cortexa8hf-neon.ipk
    install_pack ${HAFA_DIR}/update/5.2/packages/libdedab-dbg_1.0-0_cortexa8hf-neon.ipk

    install_pack ${HAFA_DIR}/update/5.2/packages/libdpi_1.0-0_cortexa8hf-neon.ipk
    install_pack ${HAFA_DIR}/update/5.2/packages/libdpi-dbg_1.0-0_cortexa8hf-neon.ipk

    install_pack ${HAFA_DIR}/update/5.2/packages/libdzgpio_1.0-0_cortexa8hf-neon.ipk
    install_pack ${HAFA_DIR}/update/5.2/packages/libdzgpio-dbg_1.0-0_cortexa8hf-neon.ipk

    install_pack ${HAFA_DIR}/update/5.2/packages/libdzprotocol_1.0-0_cortexa8hf-neon.ipk
    install_pack ${HAFA_DIR}/update/5.2/packages/libdzprotocol-dbg_1.0-0_cortexa8hf-neon.ipk

    install_pack ${HAFA_DIR}/update/5.2/packages/libepdc_1.0-0_cortexa8hf-neon.ipk
    install_pack ${HAFA_DIR}/update/5.2/packages/libepdc-dbg_1.0-0_cortexa8hf-neon.ipk

    install_pack ${HAFA_DIR}/update/5.2/packages/libgesture_1.0-0_cortexa8hf-neon.ipk
    install_pack ${HAFA_DIR}/update/5.2/packages/libgesture-dbg_1.0-0_cortexa8hf-neon.ipk

    install_pack ${HAFA_DIR}/update/5.2/packages/libjson_1.0-0_cortexa8hf-neon.ipk
    install_pack ${HAFA_DIR}/update/5.2/packages/libjson-dbg_1.0-0_cortexa8hf-neon.ipk

    install_pack ${HAFA_DIR}/update/5.2/packages/liblayout_1.0-0_cortexa8hf-neon.ipk
    install_pack ${HAFA_DIR}/update/5.2/packages/liblayout-dbg_1.0-0_cortexa8hf-neon.ipk

    install_pack ${HAFA_DIR}/update/5.2/packages/liblcd_1.0-0_cortexa8hf-neon.ipk
    install_pack ${HAFA_DIR}/update/5.2/packages/liblcd-dbg_1.0-0_cortexa8hf-neon.ipk

    install_pack ${HAFA_DIR}/update/5.2/packages/libnetworkconfig_1.0-0_cortexa8hf-neon.ipk
    install_pack ${HAFA_DIR}/update/5.2/packages/libnetworkconfig-dbg_1.0-0_cortexa8hf-neon.ipk

    install_pack ${HAFA_DIR}/update/5.2/packages/libpacos_1.0-0_cortexa8hf-neon.ipk
    install_pack ${HAFA_DIR}/update/5.2/packages/libpacos-dbg_1.0-0_cortexa8hf-neon.ipk

    install_pack ${HAFA_DIR}/update/5.2/packages/libpdfwrap_1.0-0_cortexa8hf-neon.ipk
    install_pack ${HAFA_DIR}/update/5.2/packages/libpdfwrap-dbg_1.0-0_cortexa8hf-neon.ipk

    install_pack ${HAFA_DIR}/update/5.2/packages/libpoppler_1.0-0_cortexa8hf-neon.ipk
    install_pack ${HAFA_DIR}/update/5.2/packages/libpoppler-dbg_1.0-0_cortexa8hf-neon.ipk

    install_pack ${HAFA_DIR}/update/5.2/packages/librf_1.0-0_cortexa8hf-neon.ipk
    install_pack ${HAFA_DIR}/update/5.2/packages/librf-dbg_1.0-0_cortexa8hf-neon.ipk

    install_pack ${HAFA_DIR}/update/5.2/packages/libstecasolar_1.0-0_cortexa8hf-neon.ipk
    install_pack ${HAFA_DIR}/update/5.2/packages/libstecasolar-dbg_1.0-0_cortexa8hf-neon.ipk

    install_pack ${HAFA_DIR}/update/5.2/packages/libtts_1.0-0_cortexa8hf-neon.ipk
    install_pack ${HAFA_DIR}/update/5.2/packages/libtts-dbg_1.0-0_cortexa8hf-neon.ipk

    install_pack ${HAFA_DIR}/update/5.2/packages/libups_1.0-0_cortexa8hf-neon.ipk
    install_pack ${HAFA_DIR}/update/5.2/packages/libups-dbg_1.0-0_cortexa8hf-neon.ipk
    
#    install_pack ${HAFA_DIR}/update/5.2/packages/libpng16-16_1.6.39-r0_cortexa8hf-neon.ipk
#    install_pack ${HAFA_DIR}/update/5.2/packages/libpng16-dbg_1.6.39-r0_cortexa8hf-neon.ipk

    install_pack ${HAFA_DIR}/update/5.2/packages/fw-des_1.0-0_cortexa8hf-neon.ipk
    install_pack ${HAFA_DIR}/update/5.2/packages/fw-des-dbg_1.0-0_cortexa8hf-neon.ipk

    install_pack ${HAFA_DIR}/update/5.2/packages/dz-test_1.0-0_cortexa8hf-neon.ipk
    install_pack ${HAFA_DIR}/update/5.2/packages/dz-test-dbg_1.0-0_cortexa8hf-neon.ipk

#    for entry in ${HAFA_DIR}/update/5.2/packages/*.ipk
#    do
#      echo "install: ${entry}"
#      opkg --force-reinstall install ${entry}
#      opkg --verbosity=4 --dest ${NEW_BIN_DIR} --force-reinstall install ${entry}
#      opkg -o ${NEW_BIN_DIR} --force-reinstall install ${entry}
#      rm $entry
#    done

    cd ${CUR_DIR}

    rm -rf ${HAFA_DIR}/update/tmp

    # copy files AFTER installing packages
    if [ -d ${HAFA_DIR}/update/5.2/toFs ]; then
      echo "found files for direct copy to filesystem"
      cp -r ${HAFA_DIR}/update/5.2/toFs/* /
      rm -r ${HAFA_DIR}/update/5.2/toFs/*
    fi

    # copy files AFTER installing packages
    if [ -d ${HAFA_DIR}/update/toFs/mnt/dezign/work ]; then
      echo "found files for direct copy to work directory"
      cp -r ${HAFA_DIR}/update/toFs/mnt/dezign/work/* ${HAFA_DIR}/work/
      rm -r ${HAFA_DIR}/update/toFs/mnt/dezign/work/*
    fi
    
    ;;
esac


rm -f ${HAFA_DIR}/work/ssl_cert.pem
rm -f ${HAFA_DIR}/work/*.PGM

rm -f ${HAFA_DIR}/work/*.7z

#aristech tts stuff  
if [ -f /opt/aristech/client/num.sqr ]; then
  echo "aristech: copy num.sqr file"
  mv -f ${HAFA_DIR}/update/num.sqr /opt/aristech/client/num.sqr
fi

echo "changing password"
case $(uname -r) in
  '3.8.13-bone67' )
  echo "root:deZign2016" | chpasswd
  echo "debian:deZign2016" | chpasswd
    ;;
  '5.2.7-dezign' )
    echo 'new system (kernel 5.2.7)'
  echo "root:deZign2016" | chpasswd
    ;;
esac

service ntp stop
update-rc.d -f ntp remove

echo "syncing file system ..."

sync

echo "sync finished"

echo "update finished"


if [ "$PAR1" = "init" ]; then
    echo "initial installation, do not reboot"
else
    count=$(ls -l ${HAFA_DIR}/work/*.7z 2>/dev/null | wc -l)
    if [ $count != 0 ]; then
      echo "there are more update packages in work dir present, do not reboot"
    else
      echo "no more update packages in work dir present, reboot"
    
      echo "update finished in 5"
      sleep 1
      echo "update finished in 4"
      sleep 1
      echo "update finished in 3"
      sleep 1
      echo "update finished in 2"
      sleep 1
      echo "update finished in 1"
      sleep 1
      echo "update finished in 0 (reboot)"
      sleep 1
      
      reboot
      
      sleep 30
    fi
fi

case $(uname -r) in
  '3.8.13-bone67' )
    ;;
  '5.2.7-dezign' )
    ;;
esac
