function util_getDaytimeSeconds( idHour, idMinute ) {
     return ( Number( document.getElementById( idHour ).value ) * 3600 ) +
            ( Number( document.getElementById( idMinute ).value ) * 60 )
};

function util_checkHourMinuteInputs( ownHourId,
                                     ownMinuteId,
                                     lowerHourId,
                                     lowerMinuteId,
                                     upperHourId,
                                     upperMinuteId ) {
  ownHourId     = ownHourId     || null;
  ownMinuteId   = ownMinuteId   || null;         
  lowerHourId   = lowerHourId   || null;
  lowerMinuteId = lowerMinuteId || null;         
  upperHourId   = upperHourId   || null;
  upperMinuteId = upperMinuteId || null;
  
  if( ownHourId && ownMinuteId ) {
    var t = util_getDaytimeSeconds( ownHourId, ownMinuteId );
    if( lowerHourId && lowerMinuteId ) {
      var tl = util_getDaytimeSeconds( lowerHourId, lowerMinuteId );
      if( t < tl ) {
          console.log( 'tu (' + t + ') < tl (' + tl + '), set lower time new' );
          document.getElementById( lowerHourId ).value = document.getElementById( ownHourId ).value;
          document.getElementById( lowerMinuteId ).value = document.getElementById( ownMinuteId ).value;
      }
    } else if ( upperHourId && upperMinuteId ) {
      var tu = util_getDaytimeSeconds( upperHourId, upperMinuteId );
      if( t > tu ) {                                                
          console.log( 'tl (' + t + ') > tu (' + tl + '), set upper time new' );
          document.getElementById( upperHourId ).value = document.getElementById( ownHourId ).value;   
          document.getElementById( upperMinuteId ).value = document.getElementById( ownMinuteId ).value;
      }
    }
  }                                
};


function getTraffic( amount ) {
    var traffic = Number( amount );
    var trafficUnit = 'B';
    if(      traffic > 1000000000 ) { traffic /= 1000000000; trafficUnit = 'GB'; }
    else if( traffic > 1000000    ) { traffic /= 1000000;    trafficUnit = 'MB'; }
    else if( traffic > 1000       ) { traffic /= 1000;       trafficUnit = 'kB'; }
    return { value: traffic.toFixed(2), unit: trafficUnit };
};


function getOperatingTime( sOpTime_min ) {
    var iOpTime_min = Number( sOpTime_min );
    var iOpTime_d = Math.floor( iOpTime_min / 1440 );
    var iOpTime_h = Math.floor( ( iOpTime_min % 1440 ) / 60 );
    iOpTime_min %= 60;
    var sRet = '';
    if( iOpTime_d > 0 ) {
        return iOpTime_d + ' d, ' + iOpTime_h + ' h, ' + iOpTime_min + ' m';
    } else if( iOpTime_h > 0 ) {
        return iOpTime_h + ' h, ' + iOpTime_min + ' m';
    }
    return iOpTime_min + ' m';
};


function getTrafficRatePerDay( amount, operatingTime_min ) {
    if( operatingTime_min ) { return getTraffic( amount * 1440 / Number( operatingTime_min ) ); }
    return { value: 0, unit: 'B' };
};
