// https://www.cssscript.com/demo/check-strength-passwords-pwstrength/
// view-source:https://www.cssscript.com/demo/check-strength-passwords-pwstrength/js/checkpw.js


var lstPwCfg = [
  {
    idVis : "idPwRuleLen12",
    fcnCheck : function( text, text2 ) {
      return text.length >= 12;
    }
  },
  {
    idVis : "idPwRuleLowerCase",
    fcnCheck : function( text, text2 ) {
      return /[a-z]/.test(text);
    }
  },
  {
    idVis : "idPwRuleUpperCase",
    fcnCheck : function( text, text2 ) {
      return /[A-Z]/.test(text);
    }
  },
  {
    idVis : "idPwRuleSpecialCharacter",
    fcnCheck : function( text, text2 ) {
      return /[~`!#$%\^&*+=\-\[\]\\';,/{}()|\\":<>\?]/g.test(text);
    }
  },
  {
    idVis : "idPwRuleMatchRepitition",
    fcnCheck : function( text, text2 ) {
      return text == text2;
    }
  }
];

function checkPw() {
  var boPwValid = true;
  var sPw  = document.getElementById( 'idNewPw' ).value ;
  var sPwC = document.getElementById( 'idNewPwConf' ).value ;
  for( var i=0; i<lstPwCfg.length; i++ ) {
    var oVis = document.getElementById( lstPwCfg[ i ].idVis );
    if( lstPwCfg[ i ].fcnCheck( sPw, sPwC ) ) {
      document.getElementById( lstPwCfg[ i ].idVis ).classList.add(   "clsPwTrue" );
      document.getElementById( lstPwCfg[ i ].idVis ).classList.remove("clsPwFalse");
    } else {                          
      document.getElementById( lstPwCfg[ i ].idVis ).classList.add(   "clsPwFalse");
      document.getElementById( lstPwCfg[ i ].idVis ).classList.remove("clsPwTrue" );
      boPwValid = false ;
    }
  }
  if( !boPwValid ) {
    return false;
  } else {
    return true;
  }
};

function completePwSubmit() {
  var boPwValid = checkPw();
  if( !boPwValid ) {
    alert( "password doesn't match rules" );
    return false;
  } else {
  }
};