
function ts_add( ts ) {
    row = j( '<tr/>', { "class" : 'clsTsRow' } );

    td = j( '<td/>' );
    td.append( j( '<input/>',{value:ts.name,name:'tsName',class:'clsTsName'}));
    row.append( td );

    td = j( '<td/>', {class:'clsTsStart'} );
    td.html( getHourMinuteSelector( 'start', ts.start, null, null ) );
    row.append( td );

    td = j( '<td/>', {class:'clsTsStop'} );
    td.html( getHourMinuteSelector( 'stop', ts.stop, null, null ) );
    row.append( td );

    j( '#idTimeslots' ).append( row );
};

function ts_addNew() {
    ts_add({name:'new Timeslot',start:0,stop:0});
};


function _getDaytimeSecondsFromHourMinuteSelectorFromParent( parentSelector, sName ) {
    var oHourSel = j(parentSelector).find('#hour_'+sName);
    var oMinuSel = j(parentSelector).find('#minute_'+sName);
    var iHour = j(oHourSel).prop('value');
    var iMinu = j(oMinuSel).prop('value');
    return (Number(iHour)*3600)+(Number(iMinu)*60);
};

function ts_listTimeslots(){
    var res = new Array();
    j('#idTimeslots').children('.clsTsRow').each(function(idx,elmnt){
        res.push({
            name:j(elmnt).find('.clsTsName').prop('value'),
            start:getDaytimeSecondsFromHourMinuteSelectorFromParent(elmnt, 'start' ),
            stop:getDaytimeSecondsFromHourMinuteSelectorFromParent(elmnt, 'stop' )
        });
    });
    return res;
};

function ts_submit(){
    ts_listTimeslots();
};

function ts_rsp( data ) {
    // clear timeslots
    j( '#idTimeslots' ).html( '' );

    var row, td;
    if( data.timeslots ) {
        console.log( 'received ' + data.timeslots.length + ' timeslots' );
        for( var t=0; t<data.timeslots.length; t++ ) {
            ts_add( data.timeslots[ t ] );
        }
    }
};

function loadTimeslots() {
    console.log( 'load timeslot configuration' );
    comm_action( 'ajxTimeslots', {task:'load'}, ts_rsp );
};
