#!/bin/bash

#ARITTS_APP=/opt/aristech/client/AriTTS-go-client
OUTPUT_DIR=/mnt/dezign/work/tmp
FILE_PLAY_MTX=/tmp/ttsPlay.mtx

exit_script() {
  rm -f ${FILE_PLAY_MTX}
}

if [ -f "${FILE_PLAY_MTX}" ]; then
  echo "audio out allready in progress"
else
  touch ${FILE_PLAY_MTX}

  trap exit_script EXIT SIGINT SIGABRT SIGTERM SIGTRAP SIGKILL

  if [ "$#" -gt 0 ] ; then
    #we expect refimage (without path) as par 1
    AUDIO_VOL=80 
    if [ "$#" -gt 1 ] ; then
      AUDIO_VOL=$2
    fi
    TTS_REF_IMAGE=$1
    TTS_FILE_RAW=${OUTPUT_DIR}/${TTS_REF_IMAGE}.raw

    amixer -c 1 sset 'Speaker' ${AUDIO_VOL}%

    # if playing audio file takes longer than 2 Minutes,
    # the process will be killed
    timeout 2m aplay ${TTS_FILE_RAW} -f S16_LE -c 1 -r 8000 -t raw
  else
    echo 'not enough parameter'
  fi
fi
