#!/bin/bash

#set timeout for conversion to two minutes

ARITTS_APP=/opt/aristech/client/AriTTS-go-client
ARITTS_SCR=/opt/aristech/client/num.sqr
OUTPUT_DIR=/mnt/dezign/work/tmp

dz_notify() {
  mqueue_push -m /dzMsgIn -p "$1"
}

exit_script() {
  echo "exit synth"
}

mkdir -p ${OUTPUT_DIR}

if [ "$#" -gt 1 ] ; then
  #we expect tts text as par 1 and refimage (without path) as par 2
  TTS_TEST=$1
  TTS_REF_IMAGE=$2
  TTS_FILE_RAW=${OUTPUT_DIR}/${TTS_REF_IMAGE}.raw
  TTS_FILE_RAW_TMP=/tmp/${TTS_REF_IMAGE}_synthesis_tts.raw
  OUTPUT_FILE=${OUTPUT_DIR}/${TTS_REF_IMAGE}.log

  trap exit_script EXIT SIGINT SIGABRT SIGTERM SIGTRAP SIGKILL

  sync

  echo "play ${TTS_TEST} to file ${TTS_FILE_RAW}"

  timeout 2m ${ARITTS_APP} -host localhost -port 8423 -text "${TTS_TEST}" -type "AUDIO" -voice "cle" -output ${TTS_FILE_RAW_TMP} -sqr ${ARITTS_SCR} 2>&1> ${OUTPUT_FILE}
# /opt/aristech/client/AriTTS-go-client -host localhost -port 8423 -text "test" -type "AUDIO" -voice "cle" -output ~/test1.raw -sqr /opt/aristech/client/num.sqr 2>&1> OUTPUT_FILE

  while read -r line; do
    dz_notify "${line}"
  done < ${OUTPUT_FILE}

  dz_notify "synthesis finished '${TTS_FILE_RAW}'"
  mv ${TTS_FILE_RAW_TMP} ${TTS_FILE_RAW}
  sync
  exit_script
else
  dz_notify 'not enough parameter for synthesis'
fi